/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.Triggerable;
import ddf.minim.javasound.FloatSampleBuffer;

class SampleSignal
implements AudioSignal,
Triggerable {
    private FloatSampleBuffer buffer;
    private int[] marks;
    private int markAt;

    public SampleSignal(FloatSampleBuffer floatSampleBuffer) {
        this.buffer = floatSampleBuffer;
        this.marks = new int[20];
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = -1;
        }
        this.markAt = 0;
    }

    public void generate(float[] fArray) {
        for (int i = 0; i < this.marks.length; ++i) {
            int n;
            int n2 = this.marks[i];
            if (n2 == -1) continue;
            int n3 = 0;
            for (n = n2; n < this.buffer.getSampleCount() && n3 < fArray.length; ++n) {
                int n4 = n3++;
                fArray[n4] = fArray[n4] + this.buffer.getChannel(0)[n];
            }
            this.marks[i] = n < this.buffer.getSampleCount() ? n : -1;
        }
    }

    public void generate(float[] fArray, float[] fArray2) {
        for (int i = 0; i < this.marks.length; ++i) {
            int n;
            int n2 = this.marks[i];
            if (n2 == -1) continue;
            int n3 = 0;
            for (n = n2; n < this.buffer.getSampleCount() && n3 < fArray.length; ++n) {
                int n4 = n3;
                fArray[n4] = fArray[n4] + this.buffer.getChannel(0)[n];
                int n5 = n3++;
                fArray2[n5] = fArray2[n5] + this.buffer.getChannel(1)[n];
            }
            this.marks[i] = n < this.buffer.getSampleCount() ? n : -1;
        }
    }

    public void trigger() {
        this.marks[this.markAt] = 0;
        ++this.markAt;
        if (this.markAt == this.marks.length) {
            this.markAt = 0;
        }
    }

    public void stop() {
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = -1;
        }
    }

    public float[] getChannel(int n) {
        if (n == 1) {
            return this.buffer.getChannel(0);
        }
        if (n == 2) {
            return this.buffer.getChannel(1);
        }
        Minim.error((String)("getChannel: Illegal channel number " + n));
        return null;
    }
}

